function chris_step_inject_browser2
% Loads all step-injection protocols, and creates a one plot, a "scatter-oscillogram", to 
% represent responses of all cells, arranged properly, according to their position on the
% PCA scores plot.

% Mar 17 2014: Revision.
% Jan 06 2015: New data, and linking to new data.

list = [1002;1003;1006;2003;4004;6001;13001;13002;13003;14005;17005;19001;19003;23002;23004;24002;2002;3005;
    4001;4003;16005;3001;2004;3002;21002;20001;21001;4002;1004;29006;29001;27001;2001;5001;23001;17003;16004;
    20004;3004;19004;1005;3003;27005;11003;18002;20003;18006;25005;32003;27002;36001;34004;37002;32005;14002;
    29002;77002;18001;7001;31006;25001;18005;34002;36003;16003;33002;37001;29007;11005;9003;5002;23005;30003;
    6003;25004;83003;31005;11006;24001;15001;11001;28003;30002;12002;22003;34001;17001;16002;29003;25006;24006;
    5003;31003;28001;78007;14001;31002;83002;31004;34005;18003;18004;78006;26003;24004;19002;30001;36002;22001;
    77001;22002;33001;9004;17002;11004;34003;32004;23003;35002;14003;24005;27003;16001;82001;24003;35001;78003;
    25003;7003;7002;14004;20002;37003;32001;31001;9001;78002;33003;28002;12004;12001;8001;29004;12003;10001;25002;
    80001;17004;78005;29005;6002;11002;32002;10003;9002];   % Only non-discoboxed cells!!!

s = [0.0412 -0.2695;0.0607 -1.3641;0.6134 -0.64;0.7801 -0.6858;-0.3069 -0.289;-0.1027 0.8485;0.0333 -1.0067;
    1.0426 0.4466;0.1501 -0.2089;1.1334 0.4029;0.4968 -0.0487;-1.3761 -0.11;0.2061 -0.5888;0.9179 0.0358;
    -0.469 0.1406;-0.0502 0.0452;0.12 -0.4928;0.4438 1.0227;1.1478 -0.6961;0.7908 -0.5899;0.21 0.1308;
    -0.3965 -0.2085;-0.463 0.9678;-0.09 -0.0662;0.0338 0.7148;-1.1383 -1.07;-1.3516 -0.8849;-0.2946 0.0132;
    0.3632 -0.2613;-1.0505 -0.0804;-0.5416 0.0375;-1.7973 -1.6487;-0.2292 -0.1478;0.1654 -0.1302;
    -0.0956 -0.3899;-0.4739 -1.0852;-0.2523 -0.4288;-0.3327 -0.1175;0.7852 0.7114;1.0674 -0.8036;-0.0486 -0.4368;
    0.4563 -0.006;-1.3639 -0.8835;0.4298 -0.1017;-0.4334 -0.2218;0.2689 0.6622;1.3287 0.2033;0.6297 0.4993;
    0.0637 0.2454;-1.2364 -0.0348;-1.5507 0.457;-1.5759 -1.4512;-1.1092 -0.1472;-1.0717 -0.3642;1.2535 0.8487;
    -1.4497 -1.6374;1.4287 0.0502;1.0915 1.8463;1.3103 2.0843;-0.5335 -0.1114;-0.4607 0.0354;1.517 2.3652;
    -0.3759 -0.0086;-0.9143 -0.3663;0.5056 0.1229;-1.6528 -0.4934;-0.2656 -0.9042;-1.2409 -0.9287;1.5416 1.1626;
    0.9966 0.3378;0.7222 -0.0466;-0.7132 -1.0018;-0.9423 0.4335;1.2081 0.6826;-0.5723 2.8617;1.2623 0.3248;
    -1.1304 -1.2258;1.3484 0.1374;-1.4854 -0.8008;0.9785 1.0011;0.6099 0.5223;-0.762 -1.1562;-0.7423 -0.2761;
    0.2593 -0.2604;-0.6476 2.1865;-0.8861 -0.317;0.5338 0.8735;0.8322 0.9172;-1.6072 -1.0731;-0.4711 -1.823;
    -0.3518 -0.8543;0.659 0.4332;-1.0368 -0.2144;-1.8333 -0.5536;1.2143 1.6435;0.9635 0.4152;-0.3522 0.2202;
    1.738 0.8146;-0.474 -0.9004;-0.5205 -0.8699;0.864 0.3541;1.0494 1.3272;1.3352 -0.3391;-1.4141 3.1391;
    -0.184 -0.0067;-0.2543 0.808;-0.6833 0.0581;-0.873 -0.4783;0.2217 0.9579;1.6057 0.8319;-0.6801 -0.7181;
    -1.0813 1.2572;0.6277 0.3822;0.4476 0.6355;0.7271 -0.0355;-1.5875 -0.0648;-0.2241 0.1107;-0.663 -0.0056;
    -0.5676 0.5579;0.547 1.2492;-0.0057 -0.6224;-0.2921 0.4317;0.0908 0.2141;0.423 0.2103;0.0347 -0.9598;
    -0.2322 0.7794;0.6558 -0.6067;0.3549 -0.0776;0.5333 0.0273;0.681 0.2291;0.82 0.26;0.4788 1.1137;-0.8073 -1.7876;
    -1.161 -0.4886;-0.476 0.9231;0.9696 0.0747;0.6831 0.1017;-1.0178 -0.3201;-0.18 -0.6159;0.4007 -0.5946;
    0.5828 -0.4031;0.0238 1.4899;-0.1462 0.2737;0.2862 -0.5715;0.3615 -1.0409;-0.8363 -2.4451;0.5824 0.0609;
    0.8941 -0.6906;0.9474 -1.1448;-0.6839 -0.015;0.6095 0.3337;1.3565 0.1018;-0.1815 0.8227;0.0009 0.5095;
    -0.0948 -1.7161]; % Scores (naive only)

age = [48;48;48;48;48;47;45;45;45;46;46;45;45;45;45;45;48;46;48;48;45;46;48;46;45;47;45;48;48;49;49;49;48;49;45;46;45;
    47;46;45;48;46;49;47;47;47;47;48;46;49;45;44;46;46;46;49;49;47;49;43;48;47;44;45;45;46;46;49;47;48;49;45;46;47;48;
    49;43;47;45;46;47;49;46;47;45;44;46;45;49;48;45;49;43;49;49;46;43;49;43;44;47;47;49;49;45;45;46;45;45;49;45;46;48;
    46;47;44;46;45;46;46;45;49;45;46;45;46;49;48;49;49;46;47;46;46;43;48;49;46;49;47;47;49;49;47;49;48;47;46;49;49;47;
    47;46;49;48];


directory = 'C:\Users\Arseny\Documents\4_Cells Classification\2014 data\Raw Steps\';

keyFileName = 'C:\Users\Arseny\Documents\4_Cells Classification\2014 data\cell id matches.xlsx';
[xlsNum,xlsStr] = xlsread(keyFileName, 1);
keyId = xlsNum(:,1);            % Cell ids
keyFile = xlsStr(2:end,4);      % Name of a respective abf

% Colors. Forming a kind of a gradient from green, through red, to black
%          43       44      45      46          47      48      49
myColor = [0 1 0; 0 0.5 0.5;0 0 1;  0.5 0 0.5;  1 0 0;  0.5 0 0;0 0 0];

iCounter = 1;
for(q=1:length(list))
    fprintf('%7d : ',list(q));
    pos = find(keyId==list(q));     % Find this id in the Excel sheet
    if(~isempty(pos))
        fileName = keyFile{pos};        % Find the fiel name
        fprintf('File name: %25s ',fileName);
        oops = 0;
        try
            a = abfload_silent([directory fileName]);
        catch
            oops = 1;
            fprintf('Cannot be read');
        end
        if(~oops)
            fprintf('Read successfully');
            b = squeeze(a(:,1,:)); % 2nd channel contains current, while 1st is our voltage (spikes).
            data(:,iCounter) = b(:,4);    % Save a new track
            g(iCounter) = q;    % Group
            iCounter = iCounter+1;
        end
    else
        fprintf('Missing from the list');
    end
    fprintf('\n');
end

xn = 5000;  % points to consider
data = data(1:xn,:);

xscale = xn*2;                              % Renormalization factors
yscale = (max(data(:))-min(data(:)))/2;     % (Ensure good proportions of each plot)
k = 0.7;                                    % Scaling factor (the larger - the bigger are the plots)

hF = figure;
hold on;
for(q=1:size(data,2))
    % text(s(g(q),1),s(g(q),2)-0.3,sprintf('%d (%d)',list(g(q)),age(g(q))),'FontSize',3,'Color',[1 1 1]*0.7);
    %plot((1:xn)/xscale + s(g(q),1) , data(:,q)/yscale + s(g(q),2),'-','Color',myColor(age(g(q))-42,:),'LineSmoothing','on');    
    plot(k*(1:xn)/xscale + s(g(q),1) , k*data(:,q)/yscale + s(g(q),2),'-','Color','k');    
end
hold off;
title(size(data,2));
% title('80 pA injection');

set(hF,'PaperPosition',[0 0 8 6]);
% saveas(hF,'C:\Users\Arseny\Documents\3_Model\figScatter.pdf');
print(hF,'-dpdf','-r600','C:\Users\Arseny\Documents\3_Model\figScatter.pdf')

end